/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: EipApm_error.h 55302 2015-07-30 12:38:50Z kai $:

Description:
  EtherNet/IP AP task
  Error code definitions

**************************************************************************************/

#ifndef _APM
#define _APM

/////////////////////////////////////////////////////////////////////////////////////
// Ethernet/IP Application Task
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_EIP_APM_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_EIP_APM_COMMAND_INVALID    ((TLR_RESULT)0xC05A0001L)

//
// MessageId: TLR_E_EIP_APM_PACKET_LENGTH_INVALID
//
// MessageText:
//
//  Invalid packet length.
//
#define TLR_E_EIP_APM_PACKET_LENGTH_INVALID ((TLR_RESULT)0xC05A0002L)

//
// MessageId: TLR_E_EIP_APM_PACKET_PARAMETER_INVALID
//
// MessageText:
//
//  Parameter of the packet are invalid.
//
#define TLR_E_EIP_APM_PACKET_PARAMETER_INVALID ((TLR_RESULT)0xC05A0003L)

//
// MessageId: TLR_E_EIP_APM_TCP_CONFIG_FAIL
//
// MessageText:
//
//  Configuration of TCP/IP failed.
//
#define TLR_E_EIP_APM_TCP_CONFIG_FAIL    ((TLR_RESULT)0xC05A0004L)

//
// MessageId: TLR_E_EIP_APM_CONNECTION_CLOSED
//
// MessageText:
//
//  Existing connection is closed.
//
#define TLR_E_EIP_APM_CONNECTION_CLOSED  ((TLR_RESULT)0xC05A0005L)

//
// MessageId: TLR_E_EIP_APM_ALREADY_REGISTERED
//
// MessageText:
//
//  A application is already registered.
//
#define TLR_E_EIP_APM_ALREADY_REGISTERED ((TLR_RESULT)0xC05A0006L)

//
// MessageId: TLR_E_EIP_APM_ACCESS_FAIL
//
// MessageText:
//
//  Command is not allowed.
//
#define TLR_E_EIP_APM_ACCESS_FAIL        ((TLR_RESULT)0xC05A0007L)

//
// MessageId: TLR_E_EIP_APM_STATE_FAIL
//
// MessageText:
//
//  Command not allowed at this state.
//
#define TLR_E_EIP_APM_STATE_FAIL         ((TLR_RESULT)0xC05A0008L)

//
// MessageId: TLR_E_EIP_APM_NO_CONFIG_DBM
//
// MessageText:
//
//  Database config.dpm not found.
//
#define TLR_E_EIP_APM_NO_CONFIG_DBM      ((TLR_RESULT)0xC05A0009L)

//
// MessageId: TLR_E_EIP_APM_NO_NWID_DBM
//
// MessageText:
//
//  Database nwid.dpm not found.
//
#define TLR_E_EIP_APM_NO_NWID_DBM        ((TLR_RESULT)0xC05A000AL)

//
// MessageId: TLR_E_EIP_APM_CONFIG_DBM_INVALID
//
// MessageText:
//
//  Database config.dpm invalid.
//
#define TLR_E_EIP_APM_CONFIG_DBM_INVALID ((TLR_RESULT)0xC05A000BL)

//
// MessageId: TLR_E_EIP_APM_NWID_DBM_INVALID
//
// MessageText:
//
//  Database nwid.dpm invalid.
//
#define TLR_E_EIP_APM_NWID_DBM_INVALID   ((TLR_RESULT)0xC05A000CL)

//
// MessageId: TLR_E_EIP_APM_FOLDER_NOT_FOUND
//
// MessageText:
//
//  Channel folder not found.
//
#define TLR_E_EIP_APM_FOLDER_NOT_FOUND   ((TLR_RESULT)0xC05A000DL)

//
// MessageId: TLR_E_EIP_APM_IO_OFFSET_INVALID
//
// MessageText:
//
//  Invalid dual port memory I/O offset.
//
#define TLR_E_EIP_APM_IO_OFFSET_INVALID  ((TLR_RESULT)0xC05A000EL)

//
// MessageId: TLR_E_EIP_APM_DBM_TOO_MANY_SLAVES_CONFIGURED
//
// MessageText:
//
//  Too many slaves configured.
//
#define TLR_E_EIP_APM_DBM_TOO_MANY_SLAVES_CONFIGURED ((TLR_RESULT)0xC05A000FL)




#endif  //_APM

